<?php
require_once __DIR__.'/functions.php';

$update = json_decode(file_get_contents('php://input'), true);
if (!$update) exit;

$msg = $update['message'] ?? $update['callback_query']['message'] ?? null;
$chat_id = $msg['chat']['id'] ?? null;
$user_name = trim(($msg['from']['first_name'] ?? '').' '.($msg['from']['last_name'] ?? ''));
$text = $update['message']['text'] ?? null;
$cb_data = $update['callback_query']['data'] ?? null;
$from_id = $update['message']['from']['id'] ?? $update['callback_query']['from']['id'] ?? null;

if (!$chat_id || !$from_id) exit;

// Ensure user exists
$user = user_get_or_create($from_id, $user_name ?: 'User #'.$from_id);
if (user_blocked($from_id)) {
    tg_send($chat_id, "🚫 Your account is blocked. Contact support @Twounlocks_admin .");
    exit;
}

$nav_back = ['inline_keyboard'=>[[['text'=>'⬅️ Back','callback_data'=>'back']]]];

function main_menu_kb(){
    return ['keyboard'=>[
        [['text'=>'📝 Send SMS'],['text'=>'💰 Balance']],
        [['text'=>'📑 SMS Logs'],['text'=>'➕ Top-up']],
        [['text'=>'❓ Help']]
    ], 'resize_keyboard'=>true, 'one_time_keyboard'=>false];
}

if ($cb_data==='back') { state_reset($from_id); tg_send($chat_id,"Main menu:", main_menu_kb()); exit; }

// State machine
$st = state_get($from_id);

// Commands / text buttons
if ($text === '/start' || $text==='❓ Help') {
    $help = "Welcome to <b>".APP_NAME."</b>!\n\n".
            "• 📝 <b>Send SMS</b> — choose API → enter numbers → message\n".
            "• 💰 <b>Balance</b> — check your personal balance\n".
            "• 📑 <b>SMS Logs</b> — your last 30 messages\n".
            "• ➕ <b>Top-up</b> — request balance top-up\n\n".
            "Use the buttons below.";
    tg_send($chat_id,$help, main_menu_kb());
    state_reset($from_id);
    exit;
}

if ($text==='📝 Send SMS' || $text==='/sendsms') {
    $apis = apis_enabled();
    if (!$apis) { tg_send($chat_id,"No SMS APIs are enabled. Please try later."); exit; }
    $rows = [];
    foreach ($apis as $a) {
        $rows[] = [['text'=>' '.$a['name'], 'callback_data'=>'choose_api_'.$a['id']]];
    }
    tg_send($chat_id,"Select API:", ['inline_keyboard'=>$rows]);
    state_set($from_id,'await_api',[]);
    exit;
}

if ($text==='💰 Balance' || $text==='/balance') {
    $balance = user_balance($from_id);

    $info  = "👤 <b>User Info</b>\n";
    $info .= "Name: ".htmlspecialchars($user['name'])."\n";
    $info .= "Telegram ID: <code>".$from_id."</code>\n\n";
    $info .= "💰 <b>Your current balance:</b> $".number_format($balance, 2);

    tg_send($chat_id, $info, main_menu_kb());
    exit;
}


if ($text==='📑 SMS Logs' || $text==='/logs') {
    $stmt = pdo()->prepare("SELECT recipient,status,created_at FROM sms_logs WHERE user_id=? ORDER BY id DESC LIMIT 30");
    $stmt->execute([$user['id']]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (!$rows) { tg_send($chat_id,"No logs yet."); exit; }
    $out = "📑 <b>Last 30 SMS</b>\n";
    foreach ($rows as $r) {
        $out .= "➤ To: {$r['recipient']} | {$r['status']} | ".substr($r['created_at'],0,19)."\n";
    }
    tg_send($chat_id, $out);
    exit;
}

if ($text==='➕ Top-up' || $text==='/topup') {
    tg_send($chat_id,"Enter top-up amount (e.g. 10.00) or tap Back.", ['inline_keyboard'=>[[['text'=>'⬅️ Back','callback_data'=>'back']]]]);
    state_set($from_id,'await_topup_amount',[]);
    exit;
}

// Handle callback buttons
if ($cb_data) {
    if (strpos($cb_data,'choose_api_')===0) {
        $api_id = (int)str_replace('choose_api_', '', $cb_data);


        state_set($from_id,'await_numbers',['api_id'=>$api_id]);
        tg_send($chat_id,"Enter recipient number(s). For multiple, separate with commas.\nExample: 919876543210,919933221100. Do Not add + On Number", $nav_back);
        exit;
    }
}

// Stateful inputs
switch ($st['state']) {
    case 'await_numbers':
        if (!$text) break;
        $data = $st['data']; 
        $data['numbers'] = trim($text);
        state_set($from_id,'await_message',$data);
        tg_send($chat_id,"Great. Now send the message text to deliver.", $nav_back);
        exit;

 case 'await_message':
    if (!$text) break;
    $data = $st['data']; 
    $data['message'] = $text;

    // Fetch API name safely
    $api = api_get($data['api_id']);
    $api_name = $api && !empty($api['name']) ? $api['name'] : "API #".$data['api_id'];

    // Calculate SMS parts (160 chars = 1 part)
    $msg_length = mb_strlen($data['message']);
    $parts = ceil($msg_length / 160);

    // Count recipients
    $recipients = count(array_filter(array_map('trim', explode(',', $data['numbers']))));

    // Estimate total cost
    $total_units = $recipients * $parts;
    $cost = $total_units * sms_cost_per_message();

    // Confirm
    $kb = ['inline_keyboard'=>[
        [['text'=>'✅ Send','callback_data'=>'confirm_send'], ['text'=>'⬅️ Back','callback_data'=>'back']]
    ]];
    $preview  = "Please confirm:\n<b>API:</b> ".$api_name;
    $preview .= "\n<b>Numbers:</b> <code>".htmlspecialchars($data['numbers'])."</code>";
    $preview .= "\n<b>Message:</b>\n".htmlspecialchars($data['message']);
    $preview .= "\n\n📊 <b>Estimate</b>";
    $preview .= "\nRecipients: {$recipients}";
    $preview .= "\nMessage length: {$msg_length} chars";
    $preview .= "\nParts per recipient: {$parts}";
    $preview .= "\nCost per SMS: $".number_format(sms_cost_per_message(),2);
    $preview .= "\n<b>Total estimated cost:</b> $".number_format($cost,2);

    state_set($from_id,'confirm_send',$data);
    tg_send($chat_id,$preview,$kb);
    exit;


case 'confirm_send':
    if ($cb_data==='confirm_send') {
        $data = $st['data'];
        $count = count(array_filter(array_map('trim', explode(',', $data['numbers']))));

        // Calculate parts
        $parts = ceil(mb_strlen($data['message']) / 160);
        $total_units = $count * $parts;
        $cost = $total_units * sms_cost_per_message();

        // Check balance BEFORE sending
        $balance = user_balance($from_id);
        if ($balance < $cost) {
            tg_send($chat_id,
                "🚫 Insufficient balance.\n\n".
                "💰 Your balance: $".number_format($balance, 2)."\n".
                "Required Balance: $".number_format($cost, 2)."\n\n".
                "Please top-up first.",
                main_menu_kb()
            );
            state_reset($from_id);
            exit;
        }

        // Send SMS only if enough balance
        $res = sms_send_via_api($user, $data['api_id'], $data['numbers'], $data['message']);
        $ok = $res['ok'];

        // (rest of your logic stays the same...)


        // Deduct balance only if success
        $pdo = pdo(); 
        $pdo->beginTransaction();
        $pdo->prepare("UPDATE users SET balance=balance-? WHERE id=?")
            ->execute([$cost, $user['id']]);
        $pdo->commit();

        $remaining = user_balance($from_id);

        // Extract number + message ID
        $number = $res['json']['array'][0][0] ?? $data['numbers'];
        $msgid  = $res['json']['array'][0][1] ?? 'N/A';

        // Build success message
        $msg  = "✅ SMS sent successfully";
        $msg .= "\n📱 Number: {$number}";
        $msg .= "\n🆔 Message ID: {$msgid}";
        $msg .= "\n\n💰 Remaining balance: $".number_format($remaining, 2);
        $msg .= "\n\n📊 Charged for {$total_units} SMS unit(s)";
        $msg .= "\nRecipients: {$count} | Parts per recipient: {$parts}";
        $msg .= "\nCost per SMS: $".number_format(sms_cost_per_message(),2);
        $msg .= "\nTotal charged: $".number_format($cost,2);

        tg_send($chat_id, $msg, main_menu_kb());
        state_reset($from_id);
        exit;
    }
    break;


    case 'await_topup_amount':
        if (!$text) break;
        if (!is_numeric($text) || ((float)$text)<=0) { 
            tg_send($chat_id,"Please enter a valid positive amount (e.g. 25).", $nav_back); 
            exit; 
        }
        $stmt = pdo()->prepare("INSERT INTO topup_requests(user_id, amount) VALUES(?,?)");
        $stmt->execute([$user['id'], (float)$text]);
        tg_send($chat_id,"✅ Top-up request submitted: $".number_format((float)$text,2)."\nAdmin will process shortly.", main_menu_kb());
        tg_alert_admin("💳 Top-up request: User ID {$user['id']} | Amount $text");
        state_reset($from_id);
        exit;
}

if (!$text && !$cb_data) exit;
// Fallback
tg_send($chat_id,"Please use the menu below.", main_menu_kb());
