<?php
include 'partials/header.php';

$flash = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (isset($_POST['add'])) {
    $stmt = pdo()->prepare("INSERT INTO users(telegram_id,name,balance,status) VALUES(?,?,?,?)");
    $stmt->execute([$_POST['telegram_id'], $_POST['name'], (float)$_POST['balance'], $_POST['status']]);
    $flash = 'User added successfully.';
  }
  if (isset($_POST['edit'])) {
    $stmt = pdo()->prepare("UPDATE users SET name=?, balance=?, status=? WHERE id=?");
    $stmt->execute([$_POST['name'], (float)$_POST['balance'], $_POST['status'], (int)$_POST['id']]);
    $flash = 'User updated successfully.';
  }
}

// fetch rows
$rows = pdo()->query("SELECT * FROM users ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// helper
function esc($v){ return htmlspecialchars($v ?? '', ENT_QUOTES); }
?>
<div class="container py-3">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 style="font-weight:800;margin-bottom:4px">Users</h3>
      <div class="muted-text" style="font-size:13px">Add, edit and manage user accounts</div>
    </div>
    <div>
      <a href="export.php?type=users" class="btn" style="background:linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a;border-radius:999px;padding:8px 12px;font-weight:700">
        <i class="fa-solid fa-download" style="margin-right:8px"></i> Export Users
      </a>
    </div>
  </div>

  <?php if ($flash): ?>
    <div class="alert alert-success" role="alert" style="background:linear-gradient(90deg,#dff7ea,#eaf9ff);color:#02102a;border-radius:8px;border:1px solid rgba(2,16,42,0.06);">
      <?= esc($flash) ?>
    </div>
  <?php endif; ?>

  <!-- add user form -->
  <div class="glass-panel p-3 mb-3">
    <form class="row g-2 align-items-center" method="post">
      <input type="hidden" name="add" value="1">
      <div class="col-12 col-md-3">
        <label class="form-label small muted-text">Telegram ID</label>
        <input class="form-control" name="telegram_id" placeholder="Telegram ID" required>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label small muted-text">Name</label>
        <input class="form-control" name="name" placeholder="Full name">
      </div>
      <div class="col-6 col-md-2">
        <label class="form-label small muted-text">Balance</label>
        <input class="form-control" name="balance" placeholder="0.00" value="0">
      </div>
      <div class="col-6 col-md-2">
        <label class="form-label small muted-text">Status</label>
        <select class="form-select" name="status">
          <option value="active">active</option>
          <option value="blocked">blocked</option>
        </select>
      </div>
      <div class="col-12 col-md-2 d-grid">
        <label class="form-label small" style="opacity:0">&nbsp;</label>
        <button class="btn" style="background:linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a">Add user</button>
      </div>
    </form>
  </div>

  <!-- users table (child-row approach: no extra TRs in tbody) -->
  <div class="glass-panel p-3">
    <div class="table-responsive">
      <table id="usersTable" class="table table-borderless align-middle" style="color:inherit">
        <thead>
          <tr style="opacity:0.95">
            <th style="width:60px">ID</th>
            <th>Telegram</th>
            <th>Name</th>
            <th style="width:120px">Balance</th>
            <th style="width:110px">Status</th>
            <th style="width:160px">Created</th>
            <th style="min-width:160px">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr class="user-row"
                data-userid="<?= esc($r['id']) ?>"
                data-telegram="<?= esc($r['telegram_id']) ?>"
                data-name="<?= esc($r['name']) ?>"
                data-balance="<?= esc($r['balance']) ?>"
                data-status="<?= esc($r['status']) ?>"
                style="border-top:1px solid rgba(255,255,255,0.03)">
              <td class="muted-text cell-id"><?= esc($r['id']) ?></td>
              <td class="cell-telegram"><?= esc($r['telegram_id']) ?></td>
              <td class="cell-name"><?= esc($r['name']) ?: '<span class="muted-text">—</span>' ?></td>
              <td class="cell-balance"><?= number_format((float)$r['balance'], 2) ?></td>
              <td class="cell-status">
                <?php if ($r['status'] === 'blocked'): ?>
                  <span class="badge bg-danger">blocked</span>
                <?php else: ?>
                  <span class="badge bg-success">active</span>
                <?php endif; ?>
              </td>
              <td class="muted-text cell-created"><?= esc($r['created_at'] ?? '') ?></td>
              <td>
                <div class="d-flex gap-2">
                  <button type="button" class="btn btn-sm btn-outline-action open-edit" data-id="<?= esc($r['id']) ?>" title="Edit">
                    <i class="fa-solid fa-pen-to-square"></i> Edit
                  </button>
                  <a href="#" class="btn btn-sm btn-light" title="Other">
                    <i class="fa-solid fa-ellipsis"></i>
                  </a>
                </div>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- include DataTables (jQuery required) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<!-- init DataTable and child-row edit panel (includes confirm on save) -->
<script>
(function(){
  $(document).ready(function(){
    var table = $('#usersTable').DataTable({
      pageLength: 25,
      lengthChange: true,
      ordering: true,
      columnDefs:[
        { orderable:false, targets: 6 } // disable ordering on action column
      ],
      language: {
        searchPlaceholder: "Search users, telegram id..."
      }
    });

    // open edit panel (DataTables child row)
    $(document).on('click', '.open-edit', function(){
      var $btn = $(this);
      var $tr = $btn.closest('tr');
      var row = table.row($tr);

      var id = $tr.data('userid');
      var telegram = $tr.data('telegram') || '';
      var name = $tr.data('name') || '';
      var balance = $tr.data('balance') || '0.00';
      var status = $tr.data('status') || 'active';

      var panelHtml = `
        <div class="edit-panel p-3 glass-panel" style="margin:8px 0;">
          <form class="row g-2 align-items-center edit-child-form" method="post">
            <input type="hidden" name="edit" value="1">
            <input type="hidden" name="id" value="${id}">
            <div class="col-12 col-md-3">
              <label class="form-label small muted-text">Telegram ID</label>
              <input class="form-control form-control-dark" name="telegram_id_display" value="${telegram}" disabled>
            </div>
            <div class="col-12 col-md-3">
              <label class="form-label small muted-text">Name</label>
              <input class="form-control form-control-dark" name="name" value="${name}" placeholder="Name" required>
            </div>
            <div class="col-6 col-md-2">
              <label class="form-label small muted-text">Balance</label>
              <input class="form-control form-control-dark" name="balance" value="${balance}" placeholder="Balance" required>
            </div>
            <div class="col-6 col-md-2">
              <label class="form-label small muted-text">Status</label>
              <select class="form-select form-select-dark" name="status">
                <option value="active" ${status === 'active' ? 'selected' : ''}>active</option>
                <option value="blocked" ${status === 'blocked' ? 'selected' : ''}>blocked</option>
              </select>
            </div>
            <div class="col-12 col-md-2 d-flex gap-2">
              <button class="btn btn-save" type="submit" title="Save" style="flex:1">
                <i class="fa-solid fa-floppy-disk"></i> Save
              </button>
              <button type="button" class="btn btn-cancel-child" style="flex:1">
                Cancel
              </button>
            </div>
          </form>
        </div>
      `;

      if (row.child.isShown()){
        row.child.hide();
        $tr.removeClass('shown');
      } else {
        // close any open child rows first
        table.rows().every(function(){
          if (this.child.isShown()) this.child.hide();
        });
        row.child(panelHtml).show();
        $tr.addClass('shown');

        // focus first editable input
        setTimeout(function(){
          var node = row.child().node();
          if (node) {
            var inp = node.querySelector('input[name="name"]');
            if (inp) inp.focus();
          }
        }, 80);

        // scroll into view
        $('html,body').animate({ scrollTop: $tr.offset().top - 80 }, 200);
      }
    });

    // cancel button inside child panel
    $(document).on('click', '.btn-cancel-child', function(){
      var $panel = $(this).closest('.edit-panel');
      var $tr = $panel.closest('tr').prev(); // parent row
      var row = table.row($tr);
      if (row.child.isShown()) row.child.hide();
    });

    // confirm before submit (for child edit forms)
    $(document).on('submit', '.edit-child-form', function(e){
      var ok = confirm('Save changes for this user?');
      if (!ok) {
        e.preventDefault();
        return false;
      }
      // allow submit (normal POST) — server will set flash message
      return true;
    });

    // keyboard shortcut (optional)
    $(window).on('keydown', function(e){
      if (e.key === 'n' && $(':focus').length === 0) {
        $('input[name="telegram_id"]').focus();
      }
    });
  });
})();
</script>

<!-- local styles that match the futuristic theme and improve visibility -->
<style>
:root{
  --accent-1: #7c5cff;
  --accent-2: #00e0b8;
  --muted: rgba(255,255,255,0.75);
  --panel-bg: rgba(255,255,255,0.03);
  --row-hover: rgba(124,92,255,0.04);
}
table#usersTable { color: #eaf2ff; }
table#usersTable td, table#usersTable th { vertical-align: middle; }
table#usersTable tbody tr.user-row td { padding: 12px 10px; color: #eaf2ff; background: transparent; }
table#usersTable tbody tr.user-row:hover { background: var(--row-hover); }
.edit-panel { background: linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01)); border: 1px solid rgba(255,255,255,0.06); border-radius: 10px; }
.form-control-dark, .form-select-dark {
  background: #f7fafc;
  color: #02102a;
  border: 1px solid rgba(2,16,42,0.06);
  border-radius: 8px;
  padding: 8px 10px;
  box-shadow: none;
}
.btn-outline-action {
  background: transparent;
  border: 1px solid rgba(255,255,255,0.06);
  color: #eaf2ff;
  border-radius: 8px;
  padding: .35rem .6rem;
}
.btn-outline-action:hover { background: rgba(255,255,255,0.03); color: #fff; }
.btn-save {
  background: linear-gradient(90deg,var(--accent-1),var(--accent-2));
  color: #02102a;
  border-radius: 8px;
  padding: .45rem .6rem;
  border: none;
}
.btn-cancel-child {
  background: transparent;
  border: 1px solid rgba(255,255,255,0.06);
  color: #eaf2ff;
  border-radius: 8px;
  padding: .45rem .6rem;
}
.badge.bg-danger{background:linear-gradient(90deg,#ff6b6b,#ff9b6b);color:#02102a}
.badge.bg-success{background:linear-gradient(90deg,#7be495,#00c07a);color:#02102a}
@media (max-width: 760px){
  .form-control.form-control-sm, .form-select.form-select-sm { font-size:12px; padding:.38rem .5rem }
  table#usersTable td { vertical-align: middle; font-size:13px; }
  .d-flex.gap-2 { gap: .45rem !important; }
  .edit-panel .col-12 { margin-bottom: .5rem; }
}
</style>

<?php include 'partials/footer.php'; ?>
