<?php include 'partials/header.php';

// Manual add top-up & view top-up requests
if ($_SERVER['REQUEST_METHOD']==='POST'){
  if (isset($_POST['credit'])) {
    $uid = (int)$_POST['user_id']; $amt=(float)$_POST['amount']; $method=trim($_POST['method']);
    $stmt = pdo()->prepare("UPDATE users SET balance=balance+? WHERE id=?");
    $stmt->execute([$amt,$uid]);
    pdo()->prepare("INSERT INTO topups(user_id,amount,method) VALUES(?,?,?)")->execute([$uid,$amt,$method?:'Admin']);
  }
  if (isset($_POST['req_action'])) {
    $id=(int)$_POST['id']; $act=$_POST['req_action'];
    $r = pdo()->prepare("SELECT * FROM topup_requests WHERE id=?")->execute([$id]);
    $row = pdo()->query("SELECT * FROM topup_requests WHERE id=$id")->fetch(PDO::FETCH_ASSOC);
    if ($row){
      if ($act==='approve'){
        pdo()->prepare("UPDATE users SET balance=balance+? WHERE id=?")->execute([$row['amount'],$row['user_id']]);
        pdo()->prepare("INSERT INTO topups(user_id,amount,method) VALUES(?,?,?)")->execute([$row['user_id'],$row['amount'],'Request']);
        pdo()->prepare("UPDATE topup_requests SET status='approved' WHERE id=?")->execute([$id]);
      } else if ($act==='reject'){
        pdo()->prepare("UPDATE topup_requests SET status='rejected' WHERE id=?")->execute([$id]);
      }
    }
  }
}
$topups = pdo()->query("SELECT t.*, u.telegram_id FROM topups t LEFT JOIN users u ON u.id=t.user_id ORDER BY t.id DESC")->fetchAll(PDO::FETCH_ASSOC);
$reqs   = pdo()->query("SELECT tr.*, u.telegram_id FROM topup_requests tr LEFT JOIN users u ON u.id=tr.user_id ORDER BY tr.id DESC")->fetchAll(PDO::FETCH_ASSOC);
$users  = pdo()->query("SELECT id, telegram_id, name FROM users ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h3>Top-ups</h3>
<div class="card mb-4"><div class="card-body">
  <h5>Manual Credit</h5>
  <form class="row g-2" method="post">
    <input type="hidden" name="credit" value="1">
    <div class="col-md-3">
      <select class="form-select" name="user_id" required>
        <option value="">Select user</option>
        <?php foreach($users as $u): ?>
          <option value="<?=$u['id']?>"><?=$u['id']?> | <?=$u['telegram_id']?> | <?=htmlspecialchars($u['name'])?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-2"><input class="form-control" name="amount" placeholder="Amount" required></div>
    <div class="col-md-3"><input class="form-control" name="method" placeholder="Method (e.g., UPI/Bank/PayPal)"></div>
    <div class="col-md-2"><button class="btn btn-primary w-100">Add Top-up</button></div>
  </form>
</div></div>

<div class="row g-3">
  <div class="col-lg-6">
    <h5>Top-up Requests</h5>
    <table class="table table-striped" id="dt1">
      <thead><tr><th>ID</th><th>User</th><th>Amount</th><th>Status</th><th>Created</th><th>Action</th></tr></thead>
      <tbody>
        <?php foreach($reqs as $r): ?>
        <tr>
          <td><?=$r['id']?></td><td><?=$r['user_id']?> / <?=$r['telegram_id']?></td>
          <td><?=$r['amount']?></td><td><?=$r['status']?></td><td><?=$r['created_at']?></td>
          <td>
            <?php if($r['status']=='pending'): ?>
            <form method="post" class="d-inline"><input type="hidden" name="id" value="<?=$r['id']?>"><input type="hidden" name="req_action" value="approve"><button class="btn btn-sm btn-success">Approve</button></form>
            <form method="post" class="d-inline"><input type="hidden" name="id" value="<?=$r['id']?>"><input type="hidden" name="req_action" value="reject"><button class="btn btn-sm btn-danger">Reject</button></form>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach;?>
      </tbody>
    </table>
  </div>
  <div class="col-lg-6">
    <h5>Top-up History</h5>
    <table class="table table-striped" id="dt2">
      <thead><tr><th>ID</th><th>User</th><th>Amount</th><th>Method</th><th>Date</th></tr></thead>
      <tbody>
        <?php foreach($topups as $t): ?>
        <tr><td><?=$t['id']?></td><td><?=$t['user_id']?> / <?=$t['telegram_id']?></td><td><?=$t['amount']?></td><td><?=$t['method']?></td><td><?=$t['created_at']?></td></tr>
        <?php endforeach;?>
      </tbody>
    </table>
  </div>
</div>
<script>$(function(){$('#dt1,#dt2').DataTable();});</script>
<?php include 'partials/footer.php'; ?>
