<?php
// admin/send_test.php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/auth.php';
require_login();
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

header('Content-Type: application/json; charset=utf-8');

$id  = (int)($_POST['id'] ?? 0);
$to  = trim($_POST['to'] ?? '');
$msg = trim($_POST['message'] ?? '');

if (!$id || !$to || !$msg) {
    echo json_encode(['error'=>'Missing parameters']);
    exit;
}

// fetch api row
$stmt = pdo()->prepare("SELECT * FROM sms_apis WHERE id=?");
$stmt->execute([$id]);
$api = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$api) {
    echo json_encode(['error'=>'API not found']);
    exit;
}

// build full message with API name prepended
$fullMessage = $api['name'] . ' - ' . $msg;

// base endpoint (e.g. http://.../sendsms)
$endpoint = trim($api['endpoint']);
if ($endpoint === '') {
    echo json_encode(['error'=>'No endpoint configured']);
    exit;
}

// build send URL
$sendUrl = $endpoint;
$sep = (parse_url($sendUrl, PHP_URL_QUERY) ? '&' : '?');
$sendUrl .= $sep .
    'account=' . urlencode($api['username']) .
    '&password=' . urlencode($api['password']) .
    '&smstype=0' .
    '&numbers=' . urlencode($to) .
    '&content=' . urlencode($fullMessage);

// call provider
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $sendUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 8);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERAGENT, 'MyApp-SMSTester/1.0');

$resp = curl_exec($ch);
$err  = curl_error($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($err) {
    echo json_encode(['error'=>$err,'http_code'=>$http,'url'=>$sendUrl]);
    exit;
}

echo json_encode([
    'http_code'=>$http,
    'url'=>$sendUrl,
    'response_sample'=>mb_substr((string)$resp,0,1000)
]);
