<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../auth.php';
require_login();
$me = admin_user();

// Detect current page
$current = basename($_SERVER['PHP_SELF']);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars(APP_NAME) ?> Admin</title>

  <!-- Fonts & Icons -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>

  <style>
    :root{
      --bg: #071026;
      --glass: rgba(255,255,255,0.03);
      --glass-2: rgba(255,255,255,0.02);
      --accent-1: #7c5cff;
      --accent-2: #00e0b8;
      --muted: rgba(255,255,255,0.65);
      --nav-height: 72px;
      --border-radius: 14px;
    }

    html,body{height:100%;margin:0;font-family:"Inter",system-ui,-apple-system,Segoe UI,Roboto,"Helvetica Neue",Arial;color:#eaf2ff;background:var(--bg);-webkit-font-smoothing:antialiased}

    /* Top bar / header */
    .topbar {
      position: sticky;
      top: 0;
      z-index: 1050;
      backdrop-filter: blur(8px) saturate(120%);
      -webkit-backdrop-filter: blur(8px) saturate(120%);
      background: linear-gradient(180deg, rgba(6,10,20,0.55), rgba(6,10,20,0.40));
      border-bottom: 1px solid rgba(255,255,255,0.04);
      box-shadow: 0 6px 30px rgba(2,6,23,0.5);
    }
    .topbar .container-fluid{height:var(--nav-height);display:flex;align-items:center;gap:12px}

    /* Brand */
    .brand {
      display:flex;align-items:center;gap:12px;text-decoration:none;color:inherit;
      margin-right:6px;
    }
    .brand .logo {
      width:46px;height:46px;border-radius:10px;
      display:flex;align-items:center;justify-content:center;
      background: linear-gradient(135deg,var(--accent-1),var(--accent-2));
      box-shadow: 0 8px 30px rgba(124,92,255,0.12);
      font-weight:700;font-size:18px;color:#02102a;
    }
    .brand .title {font-weight:700; font-size:15px;line-height:1; letter-spacing:0.2px}
    .brand .subtitle {font-size:11px;color:var(--muted); margin-top:-2px}

    /* Navigation (desktop) */
    .main-nav { display:flex; gap:6px; align-items:center; margin-left:6px; }
    .main-nav .nav-link {
      color: rgba(255,255,255,0.75);
      padding:10px 12px;
      border-radius:10px;
      position:relative;
      transition: transform .12s ease, color .12s ease, box-shadow .12s ease;
      font-size:14px;
    }
    .main-nav .nav-link:hover{ transform: translateY(-4px); color:#fff; box-shadow: 0 10px 30px rgba(124,92,255,0.06)}
    .main-nav .nav-link.active{
      color:#02102a;
      background: linear-gradient(90deg,var(--accent-1),var(--accent-2));
      box-shadow: 0 12px 32px rgba(124,92,255,0.14);
    }

    /* search */
    .top-search {
      min-width:240px;
      max-width:420px;
      margin-left:14px;
      position:relative;
    }
    .top-search input {
      width:100%;
      background: linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01));
      border:1px solid rgba(255,255,255,0.06);
      color:#eaf2ff;
      padding:10px 12px 10px 38px;
      border-radius:12px;
      transition: box-shadow .12s ease, transform .12s ease;
      font-size:14px;
    }
    .top-search input:focus{outline:none; box-shadow: 0 10px 30px rgba(124,92,255,0.08); transform: translateY(-2px)}
    .top-search .fa-magnifying-glass{position:absolute;left:12px;top:50%;transform:translateY(-50%);color:rgba(255,255,255,0.55)}

    /* quick actions */
    .quick-actions{display:flex;gap:8px;align-items:center;margin-left:auto;margin-right:12px}
    .qa-btn{
      height:42px; min-width:42px; display:inline-flex;align-items:center;justify-content:center;
      border-radius:10px;border:1px solid rgba(255,255,255,0.04);
      background: linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01));
      color:rgba(255,255,255,0.9);
      transition: transform .12s ease, box-shadow .12s ease;
    }
    .qa-btn:hover{transform:translateY(-4px); box-shadow:0 10px 26px rgba(2,6,23,0.6)}

    /* notifications */
    .notif-btn{position:relative}
    .notif-badge{
      position:absolute;right:-6px;top:-6px;background:linear-gradient(90deg,#ff4d6d,#ffb86b);
      color:#02102a;border-radius:999px;padding:4px 6px;font-size:11px;font-weight:700;
      box-shadow:0 6px 18px rgba(255,77,109,0.12);
      animation: pulse 2.6s infinite;
    }
    @keyframes pulse{0%{transform:scale(1)}50%{transform:scale(1.08)}100%{transform:scale(1)}}

    /* user avatar / dropdown */
    .user-box{
      display:flex;align-items:center;gap:10px;padding-left:12px;
      border-left:1px solid rgba(255,255,255,0.03);
      margin-left:12px;
    }
    .avatar {
      width:42px;height:42px;border-radius:10px;overflow:hidden;
      display:inline-flex;align-items:center;justify-content:center;
      background:linear-gradient(135deg,var(--accent-1),var(--accent-2));
      color:#02102a;font-weight:700;
      box-shadow: 0 6px 18px rgba(124,92,255,0.12);
    }
    .user-info {display:flex;flex-direction:column;line-height:1}
    .user-name{font-weight:700;font-size:13px}
    .user-email{font-size:12px;color:var(--muted)}

    /* mobile toggler */
    .mobile-toggle {
      display:none;
      margin-left:auto;
      background:transparent;border:0;color:rgba(255,255,255,0.9);
      width:48px;height:48px;border-radius:10px;display:inline-flex;align-items:center;justify-content:center;
    }

    /* mobile menu (hidden by default) */
    .mobile-menu {
      display:none;
      position:absolute;
      left:0;right:0;
      top:var(--nav-height);
      background: linear-gradient(180deg, rgba(6,10,20,0.98), rgba(6,10,20,0.96));
      border-bottom:1px solid rgba(255,255,255,0.03);
      padding:14px;
      z-index:1049;
      box-shadow: 0 12px 40px rgba(2,6,23,0.6);
    }
    .mobile-menu .m-link{
      display:block;padding:10px;border-radius:8px;color:rgba(255,255,255,0.92);text-decoration:none;margin-bottom:6px;
    }
    .mobile-menu .m-link.active{background: linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a}

    /* mobile-only utilities inside menu */
    .mobile-menu .m-search{margin-bottom:10px}
    .mobile-menu .m-quick{display:flex;gap:8px;flex-wrap:wrap}

    /* responsive - collapse/move things on small screens */
    @media (max-width: 991px){
      .main-nav{display:none}
      .top-search{display:none}
      .quick-actions{display:none}
      .user-info{display:none}
      .mobile-toggle{display:inline-flex}
    }
  </style>
</head>
<body>
  <header class="topbar">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="brand" href="index.php" aria-label="<?= htmlspecialchars(APP_NAME) ?> Admin">
        <div class="logo" aria-hidden="true"><?= htmlspecialchars(substr(APP_NAME,0,1)) ?></div>
        <div>
          <div class="title"><?= htmlspecialchars(APP_NAME) ?> Admin</div>
          
        </div>
      </a>

      <!-- Desktop nav -->
      <nav class="main-nav" role="navigation" aria-label="Main navigation">
        <a class="nav-link <?= $current === 'users.php' ? 'active' : '' ?>" href="users.php"><i class="fa-solid fa-users" style="margin-right:8px"></i>Users</a>
        <a class="nav-link <?= $current === 'apis.php' ? 'active' : '' ?>" href="apis.php"><i class="fa-solid fa-link" style="margin-right:8px"></i>APIs</a>
        <a class="nav-link <?= $current === 'topups.php' ? 'active' : '' ?>" href="topups.php"><i class="fa-solid fa-credit-card" style="margin-right:8px"></i>Top-ups</a>
        <a class="nav-link <?= $current === 'logs.php' ? 'active' : '' ?>" href="logs.php"><i class="fa-solid fa-file-lines" style="margin-right:8px"></i>SMS Logs</a>
        <a class="nav-link <?= $current === 'test_apis.php' ? 'active' : '' ?>" href="test_apis.php"><i class="fa-solid fa-vial" style="margin-right:8px"></i>Test APIs</a>
      </nav>

      <!-- search (desktop only) -->
      <div class="top-search" role="search" aria-label="Search">
        <i class="fa-solid fa-magnifying-glass"></i>
        <input id="navSearch" type="search" placeholder="Search users, logs, APIs..." aria-label="Search">
      </div>

      <!-- quick actions -->
      <div class="quick-actions" role="group" aria-label="Quick actions">
        <button class="qa-btn" title="Create user" id="btnCreateUser"><i class="fa-solid fa-user-plus"></i></button>
        <button class="qa-btn" title="Add API" id="btnAddApi"><i class="fa-solid fa-plus"></i></button>

        <!-- notifications -->
        <div class="notif-btn">
          <button class="qa-btn" id="notifToggle" aria-haspopup="true" aria-expanded="false" title="Notifications"><i class="fa-solid fa-bell"></i></button>
          <div class="notif-badge" id="notifCount">3</div>
        </div>
      </div>

      <!-- user -->
      <div class="user-box">
        <div class="avatar" aria-hidden="true"><?= htmlspecialchars(strtoupper(substr($me['email'] ?? 'A',0,1))) ?></div>
        <div class="user-info d-none d-md-flex">
          <div class="user-name"><?= htmlspecialchars($me['name'] ?? $me['email']) ?></div>
          <div class="user-email"><?= htmlspecialchars($me['email']) ?></div>
        </div>

        <!-- small dropdown actions -->
        <div class="dropdown">
          <button class="btn btn-sm" id="userMenuBtn" data-bs-toggle="dropdown" aria-expanded="false" style="background:transparent;border:0;color:rgba(255,255,255,0.65)">
            <i class="fa-solid fa-chevron-down"></i>
          </button>
          <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="userMenuBtn" style="border-radius:12px;background:linear-gradient(180deg,rgba(6,10,20,0.98),rgba(6,10,20,0.96));border:1px solid rgba(255,255,255,0.03)">
            <li><a class="dropdown-item" href="profile.php"><i class="fa-solid fa-user-gear" style="width:18px"></i> Profile & settings</a></li>
            <li><a class="dropdown-item" href="audit.php"><i class="fa-solid fa-shield-halved" style="width:18px"></i> Audit logs</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="fa-solid fa-right-from-bracket" style="width:18px"></i> Logout</a></li>
          </ul>
        </div>

        <!-- mobile menu toggler -->
        <button class="mobile-toggle" id="mobileToggle" aria-controls="mobileMenu" aria-expanded="false" aria-label="Open menu">
          <i class="fa-solid fa-bars" style="font-size:18px"></i>
        </button>
      </div>
    </div>

    <!-- Mobile collapsible menu (hidden by default, shown when toggled) -->
    <div id="mobileMenu" class="mobile-menu" aria-hidden="true">
      <!-- mobile search -->
      <div class="m-search">
        <div style="position:relative">
          <i class="fa-solid fa-magnifying-glass" style="position:absolute;left:12px;top:10px;color:rgba(255,255,255,0.5)"></i>
          <input type="search" class="form-control" placeholder="Search users, logs, APIs..." style="padding-left:40px;border-radius:10px;background:rgba(255,255,255,0.02);border:1px solid rgba(255,255,255,0.04);color:#fff">
        </div>
      </div>

      <!-- nav links -->
      <div class="m-links mb-2">
        <a class="m-link <?= $current === 'users.php' ? 'active' : '' ?>" href="users.php"><i class="fa-solid fa-users" style="margin-right:8px"></i> Users</a>
        <a class="m-link <?= $current === 'apis.php' ? 'active' : '' ?>" href="apis.php"><i class="fa-solid fa-link" style="margin-right:8px"></i> APIs</a>
        <a class="m-link <?= $current === 'topups.php' ? 'active' : '' ?>" href="topups.php"><i class="fa-solid fa-credit-card" style="margin-right:8px"></i> Top-ups</a>
        <a class="m-link <?= $current === 'logs.php' ? 'active' : '' ?>" href="logs.php"><i class="fa-solid fa-file-lines" style="margin-right:8px"></i> SMS Logs</a>
        <a class="m-link <?= $current === 'test_apis.php' ? 'active' : '' ?>" href="test_apis.php"><i class="fa-solid fa-vial" style="margin-right:8px"></i> Test APIs</a>
      </div>

      <!-- quick actions -->
      <div class="m-quick mb-2">
        <button class="qa-btn" title="Create user" id="mBtnCreateUser"><i class="fa-solid fa-user-plus"></i></button>
        <button class="qa-btn" title="Add API" id="mBtnAddApi"><i class="fa-solid fa-plus"></i></button>
        <a href="export.php?type=users" class="btn" style="background:linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a;border-radius:10px;padding:8px 12px">Export</a>
      </div>

      <!-- user actions -->
      <div style="display:flex;align-items:center;gap:12px;margin-top:6px;border-top:1px solid rgba(255,255,255,0.03);padding-top:10px">
        <div style="display:flex;align-items:center;gap:10px">
          <div class="avatar" style="width:44px;height:44px;border-radius:8px"><?= htmlspecialchars(strtoupper(substr($me['email'] ?? 'A',0,1))) ?></div>
          <div>
            <div style="font-weight:700"><?= htmlspecialchars($me['name'] ?? $me['email']) ?></div>
            <div style="font-size:12px;color:var(--muted)"><?= htmlspecialchars($me['email']) ?></div>
          </div>
        </div>
        <div style="margin-left:auto">
          <a href="profile.php" class="btn btn-sm btn-outline-light">Profile</a>
          <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
        </div>
      </div>
    </div>
  </header>

  <!-- small spacer before page body -->
  <div style="height:12px"></div>

  <div class="container py-4">

  <!-- scripts (keeps header self-contained) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    (function(){
      const toggle = document.getElementById('mobileToggle');
      const menu = document.getElementById('mobileMenu');

      function showMenu(){
        menu.style.display = 'block';
        menu.setAttribute('aria-hidden','false');
        toggle.setAttribute('aria-expanded','true');
        // animate slide down
        menu.style.transform = 'translateY(-6px)';
        menu.style.opacity = '0';
        requestAnimationFrame(()=>{
          menu.style.transition = 'transform 220ms ease, opacity 220ms ease';
          menu.style.transform = 'translateY(0)';
          menu.style.opacity = '1';
        });
      }
      function hideMenu(){
        menu.style.transition = 'transform 180ms ease, opacity 180ms ease';
        menu.style.transform = 'translateY(-6px)';
        menu.style.opacity = '0';
        setTimeout(()=>{
          menu.style.display = 'none';
          menu.setAttribute('aria-hidden','true');
          toggle.setAttribute('aria-expanded','false');
        }, 190);
      }

      toggle.addEventListener('click', (e)=>{
        const open = toggle.getAttribute('aria-expanded') === 'true';
        if(open) hideMenu(); else showMenu();
      });

      // close menu if click outside
      document.addEventListener('click', (e)=>{
        if(!menu.contains(e.target) && !toggle.contains(e.target) && window.getComputedStyle(toggle).display !== 'none'){
          if(menu.style.display === 'block') hideMenu();
        }
      });

      // wire mobile quick-action buttons
      document.getElementById('mBtnCreateUser')?.addEventListener('click', ()=> location.href='user_create.php');
      document.getElementById('mBtnAddApi')?.addEventListener('click', ()=> location.href='api_create.php');

      // keyboard: "/" to focus search (desktop), mobile search handled by tapping input
      const navSearch = document.getElementById('navSearch');
      window.addEventListener('keydown',(e)=>{ if(e.key === '/' && document.activeElement.tagName !== 'INPUT' && document.activeElement.tagName !== 'TEXTAREA'){ e.preventDefault(); navSearch?.focus(); }});
    })();
  </script>
