<?php include 'partials/header.php';

$filters = [];
$where = [];
if (!empty($_GET['status'])) { $where[]="l.status=:status"; $filters[':status']=$_GET['status']; }
if (!empty($_GET['api_id'])) { $where[]="l.api_id=:api"; $filters[':api']=(int)$_GET['api_id']; }
if (!empty($_GET['user_id'])) { $where[]="l.user_id=:user"; $filters[':user']=(int)$_GET['user_id']; }
if (!empty($_GET['from'])) { $where[]="l.created_at>=:from"; $filters[':from']=$_GET['from']." 00:00:00"; }
if (!empty($_GET['to'])) { $where[]="l.created_at<=:to"; $filters[':to']=$_GET['to']." 23:59:59"; }

$sql = "SELECT l.*, u.telegram_id, a.name api_name FROM sms_logs l
LEFT JOIN users u ON u.id=l.user_id
LEFT JOIN sms_apis a ON a.id=l.api_id";
if ($where) $sql.=" WHERE ".implode(' AND ',$where);
$sql.=" ORDER BY l.id DESC LIMIT 2000";

$stmt = pdo()->prepare($sql); $stmt->execute($filters);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
$apis = pdo()->query("SELECT id,name FROM sms_apis ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$users= pdo()->query("SELECT id,telegram_id FROM users ORDER BY id DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);
?>
<h3>SMS Logs</h3>
<form class="row g-2 mb-3">
  <div class="col-md-2">
    <select class="form-select" name="status">
      <option value="">Status</option>
      <option value="success" <?=@$_GET['status']=='success'?'selected':''?>>success</option>
      <option value="failed" <?=@$_GET['status']=='failed'?'selected':''?>>failed</option>
    </select>
  </div>
  <div class="col-md-2">
    <select class="form-select" name="api_id">
      <option value="">API</option>
      <?php foreach($apis as $a): ?>
      <option value="<?=$a['id']?>" <?=@$_GET['api_id']==$a['id']?'selected':''?>><?=$a['name']?></option>
      <?php endforeach;?>
    </select>
  </div>
  <div class="col-md-2">
    <select class="form-select" name="user_id">
      <option value="">User</option>
      <?php foreach($users as $u): ?>
      <option value="<?=$u['id']?>" <?=@$_GET['user_id']==$u['id']?'selected':''?>><?=$u['id']?> / <?=$u['telegram_id']?></option>
      <?php endforeach;?>
    </select>
  </div>
  <div class="col-md-2"><input type="date" class="form-control" name="from" value="<?=htmlspecialchars($_GET['from']??'')?>"></div>
  <div class="col-md-2"><input type="date" class="form-control" name="to" value="<?=htmlspecialchars($_GET['to']??'')?>"></div>
  <div class="col-md-2"><button class="btn btn-primary w-100">Filter</button></div>
</form>

<div class="mb-3">
  <a href="export.php?type=logs<?= $_SERVER['QUERY_STRING']? '&'.$_SERVER['QUERY_STRING'] : '' ?>" class="btn btn-outline-primary btn-sm">Export Filtered Logs (CSV)</a>
</div>

<table class="table table-striped" id="dt">
  <thead><tr>
    <th>ID</th><th>User</th><th>API</th><th>To</th><th>Status</th><th>Date</th><th>Message</th><th>API Response</th>
  </tr></thead>
  <tbody>
    <?php foreach($rows as $r): ?>
    <tr>
      <td><?=$r['id']?></td>
      <td><?=$r['user_id']?> / <?=$r['telegram_id']?></td>
      <td><?=htmlspecialchars($r['api_name'])?></td>
      <td><?=htmlspecialchars($r['recipient'])?></td>
      <td class="<?=$r['status']=='failed'?'text-danger':'text-success'?>"><?=$r['status']?></td>
      <td><?=$r['created_at']?></td>
      <td class="text-truncate" style="max-width:240px"><?=htmlspecialchars($r['message'])?></td>
      <td><details><summary>View</summary><pre class="mb-0" style="white-space:pre-wrap"><?=htmlspecialchars($r['api_response'])?></pre></details></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>$(function(){$('#dt').DataTable({pageLength:50});});</script>
<?php include 'partials/footer.php'; ?>
