<?php
require_once __DIR__.'/../config.php';
session_start();
$err='';
if ($_SERVER['REQUEST_METHOD']==='POST'){
    $email = trim($_POST['email']??'');
    $pass  = $_POST['pass']??'';
    $stmt = pdo()->prepare("SELECT * FROM admins WHERE email=?");
    $stmt->execute([$email]);
    $a = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($a && password_verify($pass, $a['pass_hash'])){
        $_SESSION['admin_id']=$a['id'];
        header("Location: index.php"); exit;
    } else $err='Invalid credentials';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Admin Login</title>

  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    :root{
      --bg1:#050611;
      --accent:#7c5cff;
      --accent-2:#00e0b8;
      --muted:rgba(255,255,255,0.65);
    }

    html,body{height:100%;margin:0}
    body{
      font-family:"Inter",sans-serif;
      background: var(--bg1);
      color:#e6eef8;
      display:flex;align-items:center;justify-content:center;
      overflow:hidden;
      padding:20px;
    }

    /* canvas layers stacked */
    canvas.layer {
      position:fixed;
      top:0;left:0;
      width:100%;height:100%;
      z-index:0;
      pointer-events:none;
    }
    canvas#nebula{z-index:0;filter:blur(30px) saturate(120%);opacity:0.95}
    canvas#starfield{z-index:1}
    canvas#comet{z-index:2}

    .login-wrap{position:relative;z-index:10;width:100%;max-width:480px}
    .neon-card{
      background:rgba(255,255,255,0.04);
      backdrop-filter:blur(12px) saturate(140%);
      border:1px solid rgba(255,255,255,0.06);
      border-radius:18px;
      padding:28px;
      box-shadow:0 10px 40px rgba(0,0,0,0.6),0 0 20px rgba(124,92,255,0.12);
    }
    h4{margin-bottom:12px}
    .form-control{
      background:rgba(255,255,255,0.05);
      border:1px solid rgba(255,255,255,0.12);
      border-radius:12px;
      color:#fff;
    }
    .form-control:focus{border-color:var(--accent);box-shadow:0 0 10px rgba(124,92,255,0.28)}
    .neon-btn{
      width:100%;border:none;border-radius:12px;
      padding:12px;font-weight:700;
      background:linear-gradient(90deg,var(--accent),var(--accent-2));
      color:#02102a;
      box-shadow:0 12px 36px rgba(124,92,255,0.24);
      transition:.18s;
    }
    .neon-btn:hover{transform:translateY(-2px);box-shadow:0 20px 50px rgba(124,92,255,0.36)}
    .error-pill{background:rgba(255,50,50,0.15);border-radius:8px;padding:10px;color:#ffd7d7;margin-bottom:10px}
    .pass-toggle{position:absolute;right:12px;top:50%;transform:translateY(-50%);cursor:pointer;color:rgba(255,255,255,0.7)}
    .input-with-icon{position:relative}

    /* small responsive tweaks */
    @media (max-width:520px){
      .neon-card{padding:18px}
    }
  </style>
</head>
<body>
  <!-- Nebula layer (blurred, colorful drifting clouds) -->
  <canvas id="nebula" class="layer" aria-hidden="true"></canvas>
  <!-- Star layer -->
  <canvas id="starfield" class="layer" aria-hidden="true"></canvas>
  <!-- Comet layer (drawn separately for crisp streaks) -->
  <canvas id="comet" class="layer" aria-hidden="true"></canvas>

  <div class="login-wrap">
    <div class="neon-card">
      <div style="display:flex;align-items:center;gap:12px;margin-bottom:10px">
        <div style="width:46px;height:46px;border-radius:10px;display:flex;align-items:center;justify-content:center;background:linear-gradient(135deg,var(--accent),var(--accent-2));box-shadow:0 6px 20px rgba(124,92,255,0.12)"><i class="fa-solid fa-rocket"></i></div>
        <div>
          <div style="font-weight:700">Admin Console</div>
          <div style="font-size:12px;color:var(--muted)">Secure access • AI-ready</div>
        </div>
      </div>

      <h4>Welcome back</h4>
      <p style="color:var(--muted);margin-bottom:12px">Sign in to manage the system.</p>

      <?php if($err):?><div class="error-pill"><?=$err?></div><?php endif;?>

      <form method="post" novalidate>
        <div class="mb-3 input-with-icon">
          <i class="fa-solid fa-user" style="position:absolute;left:10px;top:50%;transform:translateY(-50%);color:rgba(255,255,255,0.65)"></i>
          <input class="form-control" style="padding-left:40px" name="email" placeholder="Email" value="<?=htmlspecialchars($_POST['email']??'',ENT_QUOTES)?>" required>
        </div>
        <div class="mb-3 input-with-icon" style="position:relative">
          <i class="fa-solid fa-lock" style="position:absolute;left:10px;top:50%;transform:translateY(-50%);color:rgba(255,255,255,0.65)"></i>
          <input type="password" class="form-control" style="padding-left:40px" id="pass" name="pass" placeholder="Password" required>
          <span class="pass-toggle" id="togglePwd"><i class="fa-regular fa-eye"></i></span>
        </div>

        <button class="neon-btn" type="submit"><i class="fa-solid fa-right-to-bracket" style="margin-right:8px"></i>Sign in</button>
      </form>
    </div>
  </div>

  <script>
  // =========== Utilities / resize ===========
  function fitCanvas(c){
    const dpr = Math.max(1, window.devicePixelRatio || 1);
    c.width = Math.floor(window.innerWidth * dpr);
    c.height = Math.floor(window.innerHeight * dpr);
    c.style.width = window.innerWidth + 'px';
    c.style.height = window.innerHeight + 'px';
    c.getContext('2d').setTransform(dpr,0,0,dpr,0,0);
  }

  // ========= Nebula clouds =========
  (function(){
    const canvas = document.getElementById('nebula');
    const ctx = canvas.getContext('2d');
    let blobs = [];

    function init(){
      fitCanvas(canvas);
      // create several drifting nebula blobs with different hues/sizes
      blobs = [
        makeBlob(-0.2, 0.2, 900, ['#7c5cff', '#5b6bff', '#8f6eff']),
        makeBlob(0.8, -0.4, 700, ['#00e0b8', '#2be6d0', '#32a7ff']),
        makeBlob(0.1, 0.6, 1100, ['#ff6fb8', '#ff9f7a', '#7c5cff']),
      ];
      animate();
    }

    function makeBlob(normX, normY, radius, colors){
      // normX, normY are relative positions in -1..1
      return {
        x: (normX + 1) * 0.5 * window.innerWidth,
        y: (normY + 1) * 0.5 * window.innerHeight,
        tx: (Math.random()-0.5)*30,
        ty: (Math.random()-0.5)*30,
        radius: radius,
        colors: colors,
        speed: 0.02 + Math.random()*0.03,
        angle: Math.random()*Math.PI*2,
        driftAmp: 30 + Math.random()*80
      };
    }

    function drawBlob(b){
      // draw radial gradient blob
      const g = ctx.createRadialGradient(b.x, b.y, b.radius*0.05, b.x, b.y, b.radius);
      g.addColorStop(0, hexToRgba(b.colors[0], 0.65));
      g.addColorStop(0.4, hexToRgba(b.colors[1], 0.20));
      g.addColorStop(1, hexToRgba(b.colors[2], 0.0));
      ctx.globalCompositeOperation = 'screen';
      ctx.fillStyle = g;
      ctx.beginPath();
      ctx.ellipse(b.x, b.y, b.radius*1.1, b.radius*0.7, b.angle, 0, Math.PI*2);
      ctx.fill();
      ctx.globalCompositeOperation = 'source-over';
    }

    function hexToRgba(hex, alpha){
      // simple hex to rgba converter
      const c = hex.replace('#','');
      const bigint = parseInt(c,16);
      const r = (bigint>>16)&255;
      const g = (bigint>>8)&255;
      const b = bigint & 255;
      return `rgba(${r},${g},${b},${alpha})`;
    }

    function update(dt){
      ctx.clearRect(0,0,canvas.width,canvas.height);
      // subtle background tint
      ctx.fillStyle = 'rgba(2,6,18,0.35)';
      ctx.fillRect(0,0,canvas.width,canvas.height);

      for(const b of blobs){
        // drift around target
        b.angle += b.speed * 0.2;
        b.x += Math.cos(b.angle) * (b.speed * b.driftAmp * 0.6);
        b.y += Math.sin(b.angle) * (b.speed * b.driftAmp * 0.4);
        // gently nudge back to center-ish to avoid drifting off-screen
        b.x += (window.innerWidth*0.5 - b.x) * 0.002;
        b.y += (window.innerHeight*0.5 - b.y) * 0.002;
        drawBlob(b);
      }
    }

    // animation loop
    let last = performance.now();
    function animate(now){
      const dt = (now - last)/1000;
      last = now;
      update(dt);
      requestAnimationFrame(animate);
    }

    // responsive
    window.addEventListener('resize', ()=>{
      fitCanvas(canvas);
      // reposition blobs proportionally
      for(const b of blobs){
        b.x = Math.random()*window.innerWidth;
        b.y = Math.random()*window.innerHeight;
      }
    });

    init();
  })();

  // ========= Starfield (twinkling) =========
  (function(){
    const canvas = document.getElementById('starfield');
    const ctx = canvas.getContext('2d');
    let stars = [];

    function init(){
      fitCanvas(canvas);
      stars = [];
      const count = Math.max(120, Math.floor((window.innerWidth * window.innerHeight) / 6000));
      for(let i=0;i<count;i++){
        stars.push({
          x: Math.random()*window.innerWidth,
          y: Math.random()*window.innerHeight,
          r: Math.random()*1.6,
          baseAlpha: 0.2 + Math.random()*0.8,
          tw: Math.random()*Math.PI*2,
          twSpeed: 0.5 + Math.random()*1.5,
          drift: (Math.random()-0.5)*0.02
        });
      }
      animate();
    }

    function draw(){
      ctx.clearRect(0,0,canvas.width,canvas.height);
      for(const s of stars){
        s.tw += s.twSpeed * 0.01;
        s.x += s.drift;
        if(s.x < -2) s.x = window.innerWidth + 2;
        if(s.x > window.innerWidth + 2) s.x = -2;
        const a = s.baseAlpha * (0.6 + 0.4 * Math.sin(s.tw));
        ctx.fillStyle = `rgba(255,255,255,${a})`;
        ctx.beginPath();
        ctx.arc(s.x, s.y, s.r, 0, Math.PI*2);
        ctx.fill();
      }

      // faint subtle noise overlay (tiny specks)
      // This small rectangle adds subtle texture
      ctx.globalCompositeOperation = 'lighter';
      ctx.fillStyle = 'rgba(255,255,255,0.01)';
      // do not overdraw for perf; draw scattered dots
      for(let i=0;i<10;i++){
        const x = Math.random()*window.innerWidth;
        const y = Math.random()*window.innerHeight;
        ctx.fillRect(x,y,1,1);
      }
      ctx.globalCompositeOperation = 'source-over';
    }

    function animate(){
      draw();
      requestAnimationFrame(animate);
    }

    window.addEventListener('resize', ()=>{ fitCanvas(canvas); init(); });
    init();
  })();

  // ========= Comets (sharp streaks) =========
  (function(){
    const canvas = document.getElementById('comet');
    const ctx = canvas.getContext('2d');
    let comets = [];

    function init(){
      fitCanvas(canvas);
      // spawn occasionally
      setInterval(()=>{
        if(Math.random() < 0.6) spawnComet();
      }, 2000);
      animate();
    }

    function spawnComet(){
      // random start along top or left edge
      const fromLeft = Math.random() < 0.5;
      const x = fromLeft ? -50 : Math.random() * window.innerWidth * 0.6;
      const y = fromLeft ? Math.random() * window.innerHeight * 0.4 : -50;
      const vx = 3 + Math.random()*6;
      const vy = 1 + Math.random()*4;
      comets.push({
        x, y, vx, vy,
        len: 140 + Math.random()*260,
        life: 160 + Math.random()*300,
        t: 0,
        color: Math.random()<0.6 ? '255,255,255' : '220,180,255'
      });
      // limit number of comets
      if(comets.length > 6) comets.shift();
    }

    function draw(){
      ctx.clearRect(0,0,canvas.width,canvas.height);
      for(const c of comets){
        c.t += 1;
        const progress = c.t / c.life;
        const alpha = Math.max(0, 1 - progress);
        // comet body (bright head)
        const hx = c.x + c.vx * c.t;
        const hy = c.y + c.vy * c.t;

        // streak
        ctx.beginPath();
        ctx.moveTo(hx, hy);
        ctx.lineTo(hx - c.vx * c.len, hy - c.vy * c.len);
        ctx.strokeStyle = `rgba(${c.color},${0.12 + alpha*0.9})`;
        ctx.lineWidth = 2.5 + (1 - progress) * 2.5;
        ctx.lineCap = 'round';
        ctx.globalCompositeOperation = 'lighter';
        ctx.stroke();

        // bright head
        const grad = ctx.createRadialGradient(hx, hy, 0, hx, hy, 14);
        grad.addColorStop(0, `rgba(${c.color},${0.95})`);
        grad.addColorStop(0.3, `rgba(${c.color},${0.35})`);
        grad.addColorStop(1, `rgba(${c.color},0)`);
        ctx.fillStyle = grad;
        ctx.beginPath();
        ctx.arc(hx, hy, 12 * (0.6 + alpha*0.8), 0, Math.PI*2);
        ctx.fill();

        // slight trail particles
        for(let i=0;i<6;i++){
          const px = hx - c.vx * (i * (c.len/6) / c.len) * (0.8 + Math.random()*0.4);
          const py = hy - c.vy * (i * (c.len/6) / c.len) * (0.8 + Math.random()*0.4);
          ctx.fillStyle = `rgba(${c.color},${0.02 + Math.random()*0.12 * alpha})`;
          ctx.fillRect(px + (Math.random()-0.5)*6, py + (Math.random()-0.5)*6, 2, 2);
        }
      }
      // remove finished comets
      comets = comets.filter(c => c.t < c.life);
      ctx.globalCompositeOperation = 'source-over';
    }

    function animate(){
      draw();
      requestAnimationFrame(animate);
    }

    // responsive
    window.addEventListener('resize', ()=> fitCanvas(canvas));
    init();
  })();

  // ========= Password toggle =========
  (function(){
    const toggle = document.getElementById('togglePwd');
    const pwd = document.getElementById('pass');
    toggle.addEventListener('click', ()=>{
      if(pwd.type === 'password'){ pwd.type = 'text'; toggle.innerHTML = '<i class="fa-regular fa-eye-slash"></i>'; }
      else { pwd.type = 'password'; toggle.innerHTML = '<i class="fa-regular fa-eye"></i>'; }
    });
  })();

  // ensure canvases initially fit
  window.addEventListener('load', ()=>{
    ['nebula','starfield','comet'].forEach(id=>{
      const c = document.getElementById(id);
      fitCanvas(c);
    });
  });

  // end script
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
