<?php
include 'partials/header.php';

$users  = (int) pdo()->query("SELECT COUNT(*) FROM users")->fetchColumn();
$apis   = (int) pdo()->query("SELECT COUNT(*) FROM sms_apis WHERE enabled=1")->fetchColumn();
$logs   = (int) pdo()->query("SELECT COUNT(*) FROM sms_logs")->fetchColumn();
$failed = (int) pdo()->query("SELECT COUNT(*) FROM sms_logs WHERE status='failed'")->fetchColumn();

function fmt($n){ return number_format($n); }
?>
<div class="container py-3">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0" style="font-weight:800;letter-spacing:0.2px">Dashboard</h3>
      <div style="color:var(--muted);font-size:13px;margin-top:2px">Overview & quick stats</div>
    </div>

    <div class="d-flex gap-2 align-items-center">
      <a href="export.php?type=users" class="btn" style="background:linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a;border-radius:999px;padding:8px 12px;font-weight:700">
        <i class="fa-solid fa-download" style="margin-right:8px"></i> Export
      </a>
      <a href="users.php" class="btn btn-outline-light">Manage users</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-sm-6 col-md-3">
      <div class="glass-card p-3 h-100 d-flex flex-column justify-content-between">
        <div class="d-flex align-items-start justify-content-between">
          <div>
            <div class="card-title">Users</div>
            <div class="card-value" data-value="<?= $users ?>"><?= fmt($users) ?></div>
          </div>
          <div class="card-icon"><i class="fa-solid fa-users"></i></div>
        </div>
        <div class="card-foot"><small class="muted-text">Registered accounts</small></div>
      </div>
    </div>

    <div class="col-sm-6 col-md-3">
      <div class="glass-card p-3 h-100 d-flex flex-column justify-content-between">
        <div class="d-flex align-items-start justify-content-between">
          <div>
            <div class="card-title">Enabled APIs</div>
            <div class="card-value" data-value="<?= $apis ?>"><?= fmt($apis) ?></div>
          </div>
          <div class="card-icon"><i class="fa-solid fa-link"></i></div>
        </div>
        <div class="card-foot"><small class="muted-text">Active SMS providers</small></div>
      </div>
    </div>

    <div class="col-sm-6 col-md-3">
      <div class="glass-card p-3 h-100 d-flex flex-column justify-content-between">
        <div class="d-flex align-items-start justify-content-between">
          <div>
            <div class="card-title">SMS Logs</div>
            <div class="card-value" data-value="<?= $logs ?>"><?= fmt($logs) ?></div>
          </div>
          <div class="card-icon"><i class="fa-solid fa-file-lines"></i></div>
        </div>
        <div class="card-foot"><small class="muted-text">Total messages logged</small></div>
      </div>
    </div>

    <div class="col-sm-6 col-md-3">
      <div class="glass-card p-3 h-100 d-flex flex-column justify-content-between">
        <div class="d-flex align-items-start justify-content-between">
          <div>
            <div class="card-title">Failed</div>
            <div class="card-value text-danger" data-value="<?= $failed ?>"><?= fmt($failed) ?></div>
          </div>
          <div class="card-icon"><i class="fa-solid fa-triangle-exclamation"></i></div>
        </div>
        <div class="card-foot"><small class="muted-text">Delivery failures</small></div>
      </div>
    </div>
  </div>

  <hr style="border-color: rgba(255,255,255,0.04)">

  <div class="row g-3 mt-2">
    <div class="col-md-8">
      <div class="glass-panel p-3">
        <div class="d-flex align-items-center justify-content-between mb-2">
          <div style="font-weight:700">Recent activity</div>
          <div><a href="logs.php" class="btn btn-sm btn-outline-light">View all logs</a></div>
        </div>

        <?php
        $stmt = pdo()->query("SELECT id, recipient, message, status, created_at FROM sms_logs ORDER BY created_at DESC LIMIT 6");
        $recent = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$recent): ?>
          <div class="muted-text">No recent logs</div>
        <?php else: ?>
        <div class="table-responsive">
          <table class="table table-borderless align-middle mb-0" style="color:inherit">
            <thead>
              <tr style="opacity:0.8">
                <th>#</th>
                <th>Recipient</th>
                <th>Message</th>
                <th>Status</th>
                <th>When</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($recent as $r): ?>
                <tr style="border-top:1px solid rgba(255,255,255,0.02)">
                  <td style="width:60px"><?= htmlspecialchars($r['id']) ?></td>
                  <td><?= htmlspecialchars($r['recipient']) ?></td>
                  <td style="max-width:200px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;">
                    <?= htmlspecialchars(mb_substr($r['message'],0,40)) ?>
                  </td>
                  <td>
                    <?php if ($r['status'] === 'failed'): ?>
                      <span class="badge bg-danger">Failed</span>
                    <?php else: ?>
                      <span class="badge bg-success">OK</span>
                    <?php endif; ?>
                  </td>
                  <td style="white-space:nowrap;color:var(--muted)"><?= htmlspecialchars($r['created_at']) ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="col-md-4">
      <div class="glass-panel p-3 h-100">
        <div style="font-weight:700;margin-bottom:8px">Quick actions</div>
        <div class="d-grid gap-2">
          <a class="btn" href="user_create.php" style="background:linear-gradient(90deg,var(--accent-1),var(--accent-2));color:#02102a">Create user</a>
          <a class="btn btn-outline-light" href="api_create.php">Add API</a>
          <a class="btn btn-outline-light" href="topups.php">Manage top-ups</a>
          <a class="btn btn-outline-light text-danger" href="failed_logs.php">View failed messages</a>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.glass-card{
  border-radius:12px;
  background:linear-gradient(180deg,rgba(255,255,255,0.02),rgba(255,255,255,0.01));
  border:1px solid rgba(255,255,255,0.04);
  box-shadow:0 12px 30px rgba(2,6,23,0.45);
  min-height:110px;
}
.card-title{font-size:13px;color:var(--muted);margin-bottom:6px;font-weight:600}
.card-value{font-size:28px;font-weight:800}
.card-icon{width:48px;height:48px;border-radius:10px;background:linear-gradient(135deg,var(--accent-1),var(--accent-2));display:flex;align-items:center;justify-content:center;color:#02102a;font-size:18px;font-weight:700;box-shadow:0 8px 30px rgba(124,92,255,0.08)}
.glass-panel{
  border-radius:12px;
  background:linear-gradient(180deg,rgba(255,255,255,0.03),rgba(255,255,255,0.015));
  border:1px solid rgba(255,255,255,0.04);
  box-shadow:0 10px 30px rgba(2,6,23,0.45);
}
.muted-text{color:var(--muted);font-size:13px}
.badge.bg-danger{background:linear-gradient(90deg,#ff6b6b,#ff9b6b);color:#02102a}
.badge.bg-success{background:linear-gradient(90deg,#7be495,#00c07a);color:#02102a}
@media (max-width:768px){
  .card-value{font-size:22px}
  .card-icon{width:44px;height:44px}
}
</style>

<script>
(function(){
  const animElems = document.querySelectorAll('.card-value[data-value]');
  animElems.forEach(el=>{
    const target = Number(el.getAttribute('data-value')) || 0;
    const start = Math.max(0, Math.floor(target * 0.6));
    let cur = start;
    const dur = 800;
    const stepTime = Math.max(10, Math.floor(dur / Math.max(1, target - start)));
    const inc = Math.max(1, Math.ceil((target - start) / (dur / stepTime)));
    const t = setInterval(()=>{
      cur = Math.min(target, cur + inc);
      el.textContent = cur.toLocaleString();
      if (cur >= target) clearInterval(t);
    }, stepTime);
  });
})();
</script>

<?php include 'partials/footer.php'; ?>
