<?php
require_once __DIR__.'/../config.php';
require_once __DIR__.'/auth.php'; require_login();

$type = $_GET['type'] ?? '';
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="'.$type.'-'.date('Ymd-His').'.csv"');

$out = fopen('php://output','w');

if ($type==='users'){
    fputcsv($out,['id','telegram_id','name','balance','status','created_at']);
    $rows = pdo()->query("SELECT * FROM users ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
    foreach($rows as $r) fputcsv($out, [$r['id'],$r['telegram_id'],$r['name'],$r['balance'],$r['status'],$r['created_at']]);
}
elseif ($type==='topups'){
    fputcsv($out,['id','user_id','amount','method','created_at']);
    $rows = pdo()->query("SELECT * FROM topups ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
    foreach($rows as $r) fputcsv($out, [$r['id'],$r['user_id'],$r['amount'],$r['method'],$r['created_at']]);
}
elseif ($type==='logs'){
    // Optional filters passed through query string
    $filters = []; $where=[];
    if (!empty($_GET['status'])) { $where[]="status=:status"; $filters[':status']=$_GET['status']; }
    if (!empty($_GET['api_id'])) { $where[]="api_id=:api"; $filters[':api']=(int)$_GET['api_id']; }
    if (!empty($_GET['user_id'])) { $where[]="user_id=:user"; $filters[':user']=(int)$_GET['user_id']; }
    if (!empty($_GET['from'])) { $where[]="created_at>=:from"; $filters[':from']=$_GET['from']." 00:00:00"; }
    if (!empty($_GET['to'])) { $where[]="created_at<=:to"; $filters[':to']=$_GET['to']." 23:59:59"; }

    $sql = "SELECT * FROM sms_logs";
    if ($where) $sql.=" WHERE ".implode(' AND ',$where);
    $sql.=" ORDER BY id";
    $stmt = pdo()->prepare($sql); $stmt->execute($filters);
    fputcsv($out,['id','user_id','api_id','recipient','message','api_response','status','created_at']);
    while ($r=$stmt->fetch(PDO::FETCH_ASSOC)) {
        fputcsv($out, [$r['id'],$r['user_id'],$r['api_id'],$r['recipient'],$r['message'],$r['api_response'],$r['status'],$r['created_at']]);
    }
}
fclose($out);
