<?php
// check_balance.php - fixed for ?account=&password= style endpoints
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/auth.php';

$cli = (php_sapi_name() === 'cli');
if (!$cli) {
    require_login();
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
}

if ($cli) {
    $id = isset($argv[1]) ? (int)$argv[1] : 0;
} else {
    $id = (int)($_GET['id'] ?? 0);
}

header('Content-Type: application/json; charset=utf-8');

if (!$id) {
    echo json_encode(['error' => 'Invalid or missing id']);
    exit;
}

// fetch API row
$stmt = pdo()->prepare("SELECT id,name,balance_endpoint,username,password FROM sms_apis WHERE id=?");
$stmt->execute([$id]);
$api = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$api) {
    echo json_encode(['error' => 'API not found']);
    exit;
}
$balUrl = trim($api['balance_endpoint'] ?? '');
if ($balUrl === '') {
    echo json_encode(['error' => 'No balance endpoint configured for this API']);
    exit;
}

// --- Build final URL with credentials ---
$url = $balUrl;

// If endpoint already has ?account= and &password=, replace them
if (strpos($url, 'account=') !== false && strpos($url, 'password=') !== false) {
    $url = preg_replace('/account=[^&]*/', 'account=' . urlencode($api['username']), $url);
    $url = preg_replace('/password=[^&]*/', 'password=' . urlencode($api['password']), $url);
} else {
    // Otherwise, append as query params
    $sep = (parse_url($url, PHP_URL_QUERY) ? '&' : '?');
    $url .= $sep . 'account=' . urlencode($api['username']) . '&password=' . urlencode($api['password']);
}

// --- Fetch ---
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 8);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);
curl_setopt($ch, CURLOPT_USERAGENT, 'MyApp-BalanceChecker/1.0');

$response = curl_exec($ch);
$curlErr  = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($curlErr) {
    echo json_encode(['error' => $curlErr, 'url' => $url]);
    exit;
}
if ($httpCode >= 400) {
    echo json_encode(['error' => "HTTP $httpCode", 'url' => $url, 'body' => $response]);
    exit;
}

// --- Parse response ---
$trimmed = trim($response);
$decoded = json_decode($trimmed, true);

if (json_last_error() === JSON_ERROR_NONE) {
    // If JSON, look for balance field
    $balance = null;
    foreach (['balance','credit','remaining','amount'] as $k) {
        if (isset($decoded[$k])) {
            $balance = $decoded[$k];
            break;
        }
    }
    if ($balance === null) $balance = $decoded;
    echo json_encode(['balance' => $balance, 'url' => $url]);
    exit;
}

// If plain text or XML, just return trimmed string
if (preg_match('/[0-9\.,]+/', $trimmed, $m)) {
    echo json_encode(['balance' => $m[0], 'url' => $url]);
} else {
    echo json_encode(['balance' => $trimmed, 'url' => $url]);
}
